/*  Terminiere die Liste von zusammengehörenden ABKs für eine gegebene Root-ABK. */
SELECT tsystem.function__drop_by_regex('resource_timeline__abk_group__termination', 'scheduling', true, true);
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__abk_group__termination( -- lulz
    IN _abk_ix_root                   integer,
    IN _timeframe_start               timestamp,
    IN _timeframe_end                 timestamp,
    IN _write_to_disk                 bool = false,
    IN _direction                     varchar = 'forward',
    IN _scenario                      varchar = null,
    IN _checkBlockedTimes             bool = true,
    IN _austerm                       bool = true,
    IN _resource_id_main_fix__clear   bool = true,
    IN _resource_id_main_fix__set     bool = false,
    IN _loglevel                      int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
    )
      -- timeslot memory
      -- TODO TYPE! => FUNCTION scheduling.resource_timeline__abk_ab2__termination__grouped( => RETURNS TABLE AS     
     RETURNS TABLE  (
      __ab2_id            integer,
      __resource_id       integer,
      __slotStartDate     timestamp,
      __slotEndDate       timestamp,
      __type              scheduling.resource_timeline_blocktype,
      __slotFactor        numeric,
      __usage             numeric(12,8),
      __stat              text,
      __debughint         text      
    )
    AS $$
    DECLARE

        _next_start_date  timestamp  := _timeframe_start;
        _next_end_date    timestamp  := _timeframe_end;
        _children         int[];
        _abk_record       record;
        _blocktime_refcursor refcursor;

    BEGIN

      IF _austerm THEN
          PERFORM tplanterm.abk_austerm(get_all_child_abk, _resource_id_main_fix__clear)
             FROM tplanterm.get_all_child_abk(_abk_ix_root);
      END IF;

      IF NOT _austerm AND _resource_id_main_fix__clear THEN
          PERFORM scheduling.ab2_wkstplan__resource_id_main_fix__clear( a2_id )
             FROM ab2
            WHERE a2_ab_ix IN ( SELECT get_all_child_abk FROM tplanterm.get_all_child_abk(_abk_ix_root) );
      END IF;

      -- timeslot memory
      -- TODO TYPE! => FUNCTION scheduling.resource_timeline__abk_ab2__termination__grouped( => RETURNS TABLE AS
      CREATE TEMP TABLE _results (
        ab2_id        integer,
        resource_id   integer,
        slotStartDate timestamp,
        slotEndDate   timestamp,
        type          scheduling.resource_timeline_blocktype,
        slotFactor    numeric(16,6),
        usage         numeric(12,8),
        stat          text,
        debughint     text
      );


      FOR _abk_record IN (

          WITH recursive _data AS (

            SELECT
                   abk.ab_ix,  abk.ab_parentabk, 1 AS depth, ARRAY[ abk.ab_ix ]::int[] AS path
              FROM abk
             WHERE ab_ix = _abk_ix_root
             UNION
            SELECT
                   abk.ab_ix,  abk.ab_parentabk,  depth + 1,  path || abk.ab_ix
              FROM abk
              JOIN _data ON _data.ab_ix = abk.ab_parentabk
               AND abk.ab_done = false
          ),

          _data2 AS (
            SELECT
              *,
              lead( path,1, ARRAY[]::int[] ) OVER ( ORDER BY path ASC ) AS next_path
            FROM _data
          )

          SELECT ab_ix,  ab_parentabk,  path, next_path, NOT ( path <@ next_path ) AS isleaf
            FROM _data2
           ORDER BY
            CASE WHEN _direction =  'forward' THEN NOT ( path <@ next_path ) END DESC, -- isleaf, column name not available
            CASE WHEN _direction <> 'forward' THEN NOT ( path <@ next_path ) END ASC,
            CASE WHEN _direction =  'forward' THEN array_length(path,1) END DESC,
            CASE WHEN _direction <> 'forward' THEN array_length(path,1) END ASC,
            CASE WHEN _direction =  'forward' THEN path END ASC,
            CASE WHEN _direction <> 'forward' THEN path END DESC
      ) LOOP

          RAISE NOTICE 'resource_timeline__abk_group__termination: abk: %; _timeframe_start=%, _timeframe_end=%', _abk_record.ab_ix, _timeframe_start, _timeframe_end;

          IF ( _direction = 'forward' AND NOT _abk_record.isleaf ) THEN

            _children :=
              array_agg(ab_ix) FROM (
                  WITH RECURSIVE _data AS (
                      SELECT abk.ab_ix FROM abk WHERE ab_ix = _abk_record.ab_ix
                      UNION
                      SELECT abk.ab_ix FROM abk JOIN _data ON _data.ab_ix = abk.ab_parentabk and abk.ab_done = false
                  )

                  SELECT ab_ix FROM _data
              )t;

            -- we need the latest endtime of all children of this abk
            -- we need to check all children, since we could have empty abks
            _next_start_date :=
                      max( _results.slotEndDate )
                 FROM _results
                 JOIN ab2 ON _results.ab2_id = a2_id
                 JOIN abk on a2_ab_ix = ab_ix
                WHERE ab_parentabk = any( _children );

            -- wenn der Kopf bereits terminiert war
            IF _next_start_date IS null THEN
              _next_start_date := max(ab_et) FROM abk WHERE ab_parentabk = any( _children );
            END IF;

            -- wir terminieren nur einen Teil einer Stückliste
            IF _next_start_date IS null THEN
              _next_start_date := _timeframe_start; --??? _timeframe_end
            END IF;

            _next_start_date := timediff_adddays(_next_start_date, 5);

          END IF;

          IF ( _direction <> 'forward' AND _abk_record.ab_parentabk IS NOT NULL ) THEN

            -- backward: we need min starttime of the parent
            -- we need to check all children, since we could have empty abks
            _next_end_date :=
                      min( _results.slotstartDate )
                 FROM _results
                 JOIN ab2 ON _results.ab2_id = a2_id
                WHERE a2_ab_ix = any( _abk_record.path );

            -- wenn Childs bereits terminiert waren
            IF _next_end_date IS null THEN
              _next_end_date := min(ab_at) FROM abk WHERE ab_ix = any( _abk_record.path );
            END IF;

            -- wir terminieren nur einen Teil einer Stückliste
            IF _next_end_date IS null THEN
              _next_end_date := _timeframe_end; --??? _timeframe_start
            END IF;

            _next_end_date := timediff_substdays(_next_end_date, 5);

          END IF;

          IF ( NOT _write_to_disk ) THEN
              OPEN _blocktime_refcursor FOR
              SELECT
                null::int as ti_id,
                r.ab2_id as ti_a2_id,
                r.resource_id as ti_resource_id,
                r.slotStartDate as ti_date_start,
                r.slotEndDate as ti_date_end,
                r.type as ti_type,
                r.slotFactor as ti_ta_kf,
                r.usage as ti_usage,
                false as ti_conflicted
              FROM _results r
              ORDER BY r.slotStartDate;
          END IF;

          INSERT INTO _results
          SELECT * FROM scheduling.resource_timeline__abk_ab2__termination__grouped(
              _abk_ix                     => _abk_record.ab_ix,
              _timeframe_start            => _next_start_date,
              _timeframe_end              => _next_end_date,
              _write_to_disk              => _write_to_disk,
              _direction                  => _direction,
              _scenario                   => _scenario,
              _checkBlockedTimes          => _checkBlockedTimes,
              _blocktime_refcursor        => _blocktime_refcursor,
              _resource_id_main_fix__set  => _resource_id_main_fix__set,
              _loglevel                   => _loglevel
          );

          IF ( NOT _write_to_disk ) THEN
            CLOSE _blocktime_refcursor;
          END IF;

      END LOOP;

      RETURN QUERY SELECT * FROM _results ORDER BY _results.slotstartDate;

      DROP TABLE _results;

    END $$ LANGUAGE plpgsql;